---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：49-データ解析（Parsing Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **StringToNumber等のその他パースOp**：parsing_ops.ccの399行目以降を未読

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/parsing_ops.cc` 30-42行目 - AddDenseOutputShapes
- E-02: `tensorflow/core/ops/parsing_ops.cc` 45-62行目 - AddSparseOutputShapes
- E-03: `tensorflow/core/ops/parsing_ops.cc` 65-85行目 - AddRaggedOutputShapes
- E-04: `tensorflow/core/ops/parsing_ops.cc` 97-112行目 - DecodeRaw
- E-05: `tensorflow/core/ops/parsing_ops.cc` 114-139行目 - DecodePaddedRaw
- E-06: `tensorflow/core/ops/parsing_ops.cc` 141-145行目 - DecodeCompressed
- E-07: `tensorflow/core/ops/parsing_ops.cc` 147-176行目 - ParseExample(V1)
- E-08: `tensorflow/core/ops/parsing_ops.cc` 186-227行目 - ParseExampleV2
- E-09: `tensorflow/core/ops/parsing_ops.cc` 229-254行目 - ParseSingleExample
- E-10: `tensorflow/core/ops/parsing_ops.cc` 256-310行目 - ParseSequenceExample
- E-11: `tensorflow/core/ops/parsing_ops.cc` 321-399行目 - ParseSequenceExampleV2
- E-12: `機能一覧.csv` 49行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddDenseOutputShapesはprefix+dense_shapeで出力形状計算 | E-01 | ○ |
| C-02 | AddSparseOutputShapesはindices/values/shapesの3出力 | E-02 | ○ |
| C-03 | AddRaggedOutputShapesはvalues/row_splitsの出力 | E-03 | ○ |
| C-04 | DecodeRawのout_typeはhalf/float/double/int32等 | E-04 | ○ |
| C-05 | DecodeRawのデフォルトはリトルエンディアン | E-04 | ○ |
| C-06 | DecodePaddedRawは固定長バイトデコード | E-05 | ○ |
| C-07 | ParseExample(V1)のserializedは1次元ベクトル限定 | E-07 | ○ |
| C-08 | ParseExampleV2はスカラーまたはベクトル対応 | E-08 | ○ |
| C-09 | ParseExampleV2はラグド特徴量対応 | E-08 | ○ |
| C-10 | ParseSequenceExampleはコンテキスト+特徴量リストを分離 | E-10 | ○ |
| C-11 | ParseSequenceExampleV2はラグド対応 | E-11 | ○ |
| C-12 | ParseSingleExampleはserializedがスカラー | E-09 | ○ |
| C-13 | DecodeCompressedは圧縮バイト列を解凍 | E-06 | ○ |
| C-14 | DecodePaddedRawの出力幅はfixed_length/sizeof(out_type) | E-05 (129-132行目) | ○ |
| C-15 | StringToNumber等のその他パースOp | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- parsing_ops.ccの399行目以降に存在するOp（StringToNumber、DecodeCSV等）
  - 候補：parsing_ops.cc 400行目以降

## 5) リスクフラグ（レビュー観点）
- 0: DecodeRaw/ParseExample/ParseSequenceExampleの主要Op（全て確認済み）
- 0: V1/V2の差異（ソースコードで確認済み）
- 1: 後半部分のOp定義（StringToNumber等）

## 6) レビュアーチェックリスト（最小）
- [ ] parsing_ops.ccの後半部分（StringToNumber、DecodeCSV等）を確認
- [ ] Python APIとC++ Opのパラメータ対応を確認
- [ ] パースエラー時の具体的なエラーメッセージを確認
